/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IndexPersistence;
import gnu.trove.set.hash.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class VariablePHPEntryValue
extends AbstractPHPEntryValue {
    private static final byte TYPE_PARAMETER = 1;
    private static final byte TYPE_LOCAL = 2;
    private static final byte TYPE_FIELD = 3;
    private byte kind = 0;
    private Set<Object> types;

    public VariablePHPEntryValue(int modifiers, boolean isParameter, boolean isLocalVariable, boolean isField, Object type, int pos, String nameSpace) {
        super(modifiers, nameSpace);
        if (isParameter) {
            this.kind = 1;
        } else if (isLocalVariable) {
            this.kind = (byte)2;
        } else if (isField) {
            this.kind = (byte)3;
        }
        this.types = new THashSet(1);
        if (type != null) {
            this.types.add(type);
        }
        this.setStartOffset(pos);
    }

    public VariablePHPEntryValue(int modifiers, boolean isParameter, boolean isLocalVariable, boolean isField, Set<Object> types, int pos, String nameSpace) {
        super(modifiers, nameSpace);
        if (isParameter) {
            this.kind = 1;
        } else if (isLocalVariable) {
            this.kind = (byte)2;
        } else if (isField) {
            this.kind = (byte)3;
        }
        if (types != null) {
            this.types = new THashSet(types.size());
            this.types.addAll(types);
        }
        this.setStartOffset(pos);
    }

    public VariablePHPEntryValue(DataInputStream di) throws IOException {
        super(di);
        this.internalRead(di);
    }

    public void setType(Object type) {
        this.types = new THashSet(1);
        this.types.add(type);
    }

    public void addType(Object type) {
        if (this.types == null) {
            this.types = new THashSet(1);
        }
        this.types.add(type);
    }

    public Set<Object> getTypes() {
        if (this.types == null) {
            return Collections.emptySet();
        }
        return this.types;
    }

    public boolean isLocal() {
        return this.kind == 2;
    }

    public boolean isField() {
        return this.kind == 3;
    }

    public boolean isParameter() {
        return this.kind == 1;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariablePHPEntryValue other = (VariablePHPEntryValue)obj;
        return this.kind == other.kind;
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    protected void internalWrite(DataOutputStream da) throws IOException {
        da.write(this.kind);
        IndexPersistence.writeTypeSet(this.types, da);
    }

    @Override
    protected void internalRead(DataInputStream di) throws IOException {
        this.kind = di.readByte();
        this.types = IndexPersistence.readTypeSet(di);
    }
}

